﻿using System;
using System.Data.SQLite;
using DataAccess.DataTables;
using DataAccess.DataRows;

namespace DataAccess.TableAdapters
{
    public class ResponseHistoryTableAdapter
    {
        public ResponseHistoryDataTable FillByAll()
        {
            ResponseHistoryDataTable dt = new ResponseHistoryDataTable();
            SQLiteConnection conn = ConnectionProxy.GetConnection();

            try
            {
                conn.Open();
                SQLiteCommand selectAll = new SQLiteCommand(conn);
                selectAll.CommandText = "SELECT * FROM RESPONSE_HISTORY";

                SQLiteDataAdapter da = new SQLiteDataAdapter(selectAll);
                da.Fill(dt);
            }
            catch (SQLiteException ex)
            {
                dt = null;
            }
            finally
            {
                conn.Close();
            }

            return dt;
        }

        public bool InsertResponse(string type)
        {
            SQLiteConnection conn = ConnectionProxy.GetConnection();
            bool success = true;

            try
            {
                conn.Open();
                SQLiteCommand insert = new SQLiteCommand(conn);
                insert.CommandText = "INSERT INTO RESPONSE_HISTORY (DATE, TYPE) VALUES(date('now'),'" + type + "')";

                if (insert.ExecuteNonQuery() < 1)
                {
                    throw new Exception("Error inserting in to RESPONSE_HISTORY table.");
                }
            }
            catch (SQLiteException ex)
            {
                success = false;
            }
            finally
            {
                conn.Close();
            }

            return success;
        }
    }
}